//=============================================================================
// Metals.
//=============================================================================
class Dingleberrium extends Metals;

#exec MESH IMPORT MESH=Crystal ANIVFILE=C:\DeusEx\MODELS\Crystal_a.3d DATAFILE=C:\DeusEx\MODELS\Crystal_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=Crystal X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=Crystal SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=Crystal SEQ=Still STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP NEW MESHMAP=Crystal MESH=Crystal
#exec MESHMAP SCALE MESHMAP=Crystal X=.9 Y=.9 Z=.9

#exec TEXTURE IMPORT NAME=GreenCrystals FILE=C:\DeusEx\Markistan\Textures\GreenCrystals.pcx GROUP=Skins FLAGS=2
#exec TEXTURE IMPORT NAME=GreenCrystals FILE=C:\DeusEx\Markistan\Textures\GreenCrystals.pcx GROUP=Skins PALETTE=GreenCrystals

#exec MESHMAP SETTEXTURE MESHMAP=Crystal NUM=1 TEXTURE=GreenCrystals

auto state Pickup
{
	function Frob(Actor Frobber, Inventory frobWith)
	{
		local MarkusGrayMale player;

		Super.Frob(Frobber, frobWith);

		player = MarkusGrayMale(Frobber);

		if (player != None)
		{
			player.Metals += numMetals;
			player.ClientMessage(Sprintf(msgMetalsAdded, numMetals));
			player.FrobTarget = None;
			Destroy();
		}
	}
}

defaultproperties
{
     numMetals=100
     msgMetalsAdded="%d metals added"
     FragType=Class'DeusEx.Rockchip'
     ItemName="Dingleberrium"
     PickupViewMesh=LodMesh'Markistan.Crystal'
     Mesh=LodMesh'Markistan.Crystal'
     CollisionRadius=8.000000
     CollisionHeight=12.000000
     Mass=20.000000
     Buoyancy=30.000000
}
